local t = Def.ActorFrame{};

local function GetDifficultyColor(pn)
	local IsStepsOrTrail
	if GetCurrentSteps(pn) == nil then
		return "Difficulty_Edit"
	else
		IsStepsOrTrail = GetCurrentStepsOrTrail(pn)
	end
	local GetSteps = IsStepsOrTrail
	local difficulty = GetSteps:GetDifficulty()
	return difficulty
end

local function GetMeterOnly(pn)
	local IsStepsOrTrail
	if GetCurrentSteps(pn) == nil then
		return 1
	else
		IsStepsOrTrail = GetCurrentStepsOrTrail(pn)
	end
	local GetSteps = IsStepsOrTrail
	local difficulty = GetSteps:GetDifficulty()
	local Meter = GetSteps:GetMeter()
	return Meter
end

for pn in ivalues(GAMESTATE:GetEnabledPlayers()) do
	t[#t+1] = Def.ActorFrame {
	InitCommand=function(self) if pn == PLAYER_1 then self:x(Left()+50) else self:x(Right()-50) end self:y(Top()+20):zoom(0.8) end;
		LoadFont("Common Normal")..{
			Name="Difficulty";
			OnCommand=function(self)
				local newMeter = string.match(GetDescription(pn),"%([%d]+.%d%)")
				if newMeter then
					if GetCurrentSong() then
						self:settext(string.format("%.1f",(newMeter:gsub("%(",""):gsub("%)","")) * RateModUpdateFunction()))
					else
						self:settext("?")
					end
				else
					if GetCurrentSong() then
						self:settext(string.format("%.1f",GetMeter(pn) * RateModUpdateFunction()))
					else
						self:settext("?")
					end
				end
				self:diffuse(Black())
			end;
		};
		Def.Quad { -- Mask Quad
			InitCommand=function(self)
				local rZ
				if pn == PLAYER_1 then rZ = 20 else rZ = -20 end
				self:draworder(-1):x(48):setsize(16,48):rotationz(rZ):diffuse(Black()):zwrite(true):blend(10)
			end
		};
		Def.Quad { -- Mask Quad
			InitCommand=function(self)
				local rZ
				if pn == PLAYER_1 then rZ = 20 else rZ = -20 end
				self:draworder(-1):x(-48):setsize(16,48):rotationz(rZ):diffuse(Black()):zwrite(true):blend(10)
			end
		};
		Def.Quad {
			InitCommand=cmd(draworder,-1;setsize,96,32;zwrite,true;ztest,true);
			OnCommand=function(self) self:diffuse(CustomDifficultyToColor(GetDifficultyColor(pn))) end;
		};
	};
end

return t